Rem
Rem $Header: create_queues.sql 11-jul-2003.15:49:50 kbittler Exp $
Rem
Rem create_queues.sql
Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      create_queues.sql - Creates queues used for this sample.
Rem
Rem    DESCRIPTION
Rem      It creates two queues with payload of type BOOK_ORDER_T:
Rem        MGW_BOOK_SRC, MGW_BOOK_DEST.
Rem
Rem    NOTES
Rem      This script assumes that create_users.sql has already been run.
Rem

connect mgwuser/mgwuser
set serveroutput on

CREATE OR REPLACE TYPE book_order_t AS OBJECT
(
  order_no        number,
  book_name       varchar2(100),
  book_isbn       varchar2(15),
  book_amount     number,
  payment         varchar2(30),
  ship_addr       varchar2(160),
  order_date      date 
);
/

grant execute on mgwuser.book_order_t to public;

Rem create queue table and queue
begin
    dbms_aqadm.create_queue_table(
                   queue_table => 'mgw_book_mc',
                   queue_payload_type => 'mgwuser.book_order_t',
                   multiple_consumers => TRUE);

    dbms_aqadm.create_queue(queue_name =>'mgw_book_src',
                            queue_table => 'mgw_book_mc',
                            max_retries => 1000);

    dbms_aqadm.start_queue('mgw_book_src');

    dbms_aqadm.create_queue_table(
                   queue_table => 'mgw_book_sc',
                   queue_payload_type => 'mgwuser.book_order_t',
                   multiple_consumers => FALSE);

    dbms_aqadm.create_queue(queue_name =>'mgw_book_dest',
                            queue_table => 'mgw_book_sc',
                            max_retries => 1000);

    dbms_aqadm.start_queue('mgw_book_dest');
end;
/
